package danvojtekdm;

import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.exceptions.ScriptedAgentException;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import cz.cuni.utils.Config;
import java.io.File;
import java.util.ArrayList;

/**
 *  NOTE: Class with agent must be marked also in manifest.mf, otherwise IDE don't know, which file it should run.
 *
 *  WARNING: you need to set the path to the planfile, edit getPlanFile() method!
 */
public class Main extends SPoshBot {
    
    /** Creates a new instance of agent. */
    public Main() throws ScriptedAgentException {
        super();        
    }
    
    protected JavaBehaviour getBehaviour() {
        return new MyBehaviour("MyBehaviour", this.log, this);
    }
    
    protected String getPlanFile() {
        return Config.getProjectsPath()+File.separator+"DanVojtek-DM-SPOSH"+File.separator+"src"+File.separator+"danvojtekdm"+File.separator+"sposhPlan.lap";
    }
    
    protected void prePrepareAgent()  throws PogamutException {        
        super.prePrepareAgent();
        /* Prepares agent logic to run - like initializing neural networks etc.
        not for establishing communication! */
    }
    
    protected void postPrepareAgent() throws PogamutException {        
        super.postPrepareAgent();
        /* Prepare logic according to information from gathered from startCommunication
        like choosing plan/parameters according to game type. */
        // searching for weapons available in the game
        ArrayList<Weapon> weaps = this.getMemory().getKnownWeapons();
        for (Weapon weap : weaps)
        	((MyBehaviour)this.behaviour).itemsToRunAround.add(weap);
        this.log.info("Items to run around initialized to: " + ((MyBehaviour)this.behaviour).itemsToRunAround.toString());
        body.initializer.setBotSkillLevel(3);
    }
    
    private boolean first = true;
    
    protected void doLogic() {
        if (first) { // workaround :-(
            this.getBody().configureAutoTrace(false);
            first = false;
        }
        super.doLogic();
    }    
    
    protected void shutdownAgent() throws PogamutException {        
        super.shutdownAgent();
        /* Clean up after the end of simulation of agent */
    }
    
    public static void main(String[] args) {
    }
}
